//OS version = ubuntu 16.04 LTS
//Scilab version 5.5.2

clear;
clc;

lambda=1;                      			// defining λ

d=lambda/4;                 			 //distance between the dipoles= λ/4

k=(2*%pi)/lambda;     			 //defining constant k=2 π/ λ

beta= 0;                         	//defining beta as phase difference between the dipoles

theta=0:0.01:2*%pi;                		//theta varies from 0 ˚ to 360˚

subplot(2,2,1);

polarplot(theta,abs(cos(theta)));           	 //to plot single element pattern 
  
title('ELEMENT PATTERN');

AF=cos(0.5*(d*k*cos(theta)+beta))        	//Expression for Array factor

subplot(2,2,2);

polarplot(theta,abs(AF));                    		//to plot array factor pattern

title('ARRAY FACTOR PATTERN');

subplot(2,2,3.5);

polarplot(theta,abs(cos(theta)).*abs(AF));     	//to plot total field of the array

title('TOTAL ARRAY PATTERN');






